/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class DogModel
extends EntityModel<Dog> {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public ModelPart root;
    public Optional<ModelPart> earLeft;
    public Optional<ModelPart> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;

    public DogModel(ModelPart box) {
        this.root = box;
        this.head = box.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = box.m_171324_("body");
        this.mane = box.m_171324_("upper_body");
        this.legBackRight = box.m_171324_("right_hind_leg");
        this.legBackLeft = box.m_171324_("left_hind_leg");
        this.legFrontRight = box.m_171324_("right_front_leg");
        this.legFrontLeft = box.m_171324_("left_front_leg");
        this.tail = box.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    public DogModel(ModelPart box, Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
        this.root = box;
        this.head = box.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = box.m_171324_("body");
        this.mane = box.m_171324_("upper_body");
        this.legBackRight = box.m_171324_("right_hind_leg");
        this.legBackLeft = box.m_171324_("left_hind_leg");
        this.legFrontRight = box.m_171324_("right_front_leg");
        this.legFrontLeft = box.m_171324_("left_front_leg");
        this.tail = box.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    protected void addOptionalParts(ModelPart box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<ModelPart> getChildIfPresent(ModelPart box, String name) {
        if (!box.m_233562_(name)) {
            return Optional.empty();
        }
        return Optional.of(box.m_171324_(name));
    }

    public static LayerDefinition createBodyLayer() {
        return DogModel.createBodyLayerInternal(CubeDeformation.f_171458_);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.m_171576_();
        float var2 = 13.5f;
        PartDefinition var3 = var1.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = var3.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).m_171514_(0, 10).m_171488_(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), PartPose.f_171404_);
        real_head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.m_171599_("right_hind_leg", var4, PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("left_hind_leg", var4, PartPose.m_171419_((float)1.5f, (float)16.0f, (float)7.0f));
        var1.m_171599_("right_front_leg", var4, PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.m_171599_("left_front_leg", var4, PartPose.m_171419_((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        switch (pose) {
            case FAINTED: {
                this.setupFaintPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FAINTED_2: {
                this.setupFaintPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case SIT: {
                this.setUpSitPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST: {
                this.setupRestPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case LYING_2: {
                this.setupLyingPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case DROWN: {
                this.setupDrownPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FLYING: {
                this.setupFlyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST_BELLY: {
                this.setupRestBellyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            default: {
                this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = Mth.m_14089_((float)(limbSwing * 0.6662f));
        float w1 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = Mth.m_14036_((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.f_104203_ += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.f_104202_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.f_104203_ += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.f_104201_ += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.f_104202_ += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().f_104203_ += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().f_104205_ += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().f_104203_ += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().f_104205_ += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().f_104201_ += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.f_104203_ += w * 1.4f * limbSwingAmount;
        this.legBackLeft.f_104203_ += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.f_104203_ += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.f_104203_ += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = Mth.m_14205_((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void setUpSitPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-9.0f, (float)-2.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-18.0f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-2.0f, (float)0.0f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)-45.0f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-4.0f, (float)-2.0f));
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
    }

    public void setupFaintPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)6.2f, (float)4.97f, (float)-2.04f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)-0.5f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-22.5f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-15.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-30.0f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)-1.0f, (float)-1.0f, (float)0.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-7.5f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)1.0f, (float)-0.25f, (float)0.0f));
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)162.35f, (float)11.59f, (float)38.36f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.29f, (float)0.15f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)0.75f));
        this.root.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)90.0f));
        this.root.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-5.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)40.11192f, (float)-29.43433f, (float)-3.24563f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.25f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)38.7522f, (float)-4.33973f, (float)12.33768f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.25f, (float)0.0f));
        }
    }

    public void setupFaintPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)4.34f, (float)-4.46f, (float)16.94f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.0f, (float)0.25f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.5f, (float)-1.5f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)87.38f, (float)-17.48f, (float)0.79f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.5f, (float)-1.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)90.0f, (float)22.5f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.5f, (float)-1.25f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-88.01f, (float)24.9f, (float)-2.33f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-91.14f, (float)-29.72f, (float)4.31f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.0f, (float)0.0f));
        this.tail.f_104203_ = dog.getTailRotation();
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)62.36f, (float)-4.65f, (float)2.29f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.17f, (float)-7.48f, (float)-1.35f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)51.29f, (float)23.61f, (float)-14.74f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)53.71f, (float)-14.26f, (float)10.25f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupRestPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)-7.54f, (float)0.76f, (float)2.5f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-5.0f, (float)2.0f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.f_104203_ = dog.getTailRotation();
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)-40.0f, (float)0.0f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupLyingPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)27.5f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)2.0f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.f_104203_ = dog.getTailRotation();
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupFlyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)84.84f, (float)-5.13f, (float)-5.65f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.18f, (float)-1.63f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-84.33f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-100.98f, (float)0.0f, (float)0.0f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)78.49f, (float)0.0f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.85f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)59.61f, (float)0.0f, (float)0.0f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.85f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-9.67f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.21f, (float)0.46f));
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)-13.12f, (float)0.0f, (float)0.0f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)2.03f, (float)0.0f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)1.02f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-1.03f, (float)-1.32f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)-55.69f, (float)2.98f, (float)-3.43f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.35f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)-55.69f, (float)-2.98f, (float)3.43f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.35f, (float)0.0f));
        }
    }

    public void setupDrownPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)35.0f, (float)0.0f, (float)0.0f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.25f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)-22.5f, (float)0.0f, (float)0.0f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)1.5f, (float)-2.5f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)0.0f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f));
        this.tail.f_104203_ = dog.getTailRotation();
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)-2.0f));
    }

    public void setupRestBellyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.m_252899_(KeyframeAnimations.m_253186_((float)-38.87f, (float)-25.09f, (float)-23.41f));
        this.head.m_252854_(KeyframeAnimations.m_253126_((float)-0.01f, (float)-1.9f, (float)0.36f));
        this.body.m_252899_(KeyframeAnimations.m_253186_((float)-18.36f, (float)14.74f, (float)22.42f));
        this.body.m_252854_(KeyframeAnimations.m_253126_((float)0.21f, (float)-3.81f, (float)-0.83f));
        this.legBackRight.m_252899_(KeyframeAnimations.m_253186_((float)-26.7f, (float)14.23f, (float)47.53f));
        this.legBackRight.m_252854_(KeyframeAnimations.m_253126_((float)-0.09f, (float)-3.49f, (float)-0.65f));
        this.legBackLeft.m_252899_(KeyframeAnimations.m_253186_((float)-38.05f, (float)-3.87f, (float)0.0f));
        this.legBackLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.09f, (float)-6.17f, (float)-2.3f));
        this.legFrontRight.m_252899_(KeyframeAnimations.m_253186_((float)-42.32f, (float)19.74f, (float)41.58f));
        this.legFrontRight.m_252854_(KeyframeAnimations.m_253126_((float)-0.5f, (float)-2.0f, (float)1.18f));
        this.legFrontLeft.m_252899_(KeyframeAnimations.m_253186_((float)-29.77f, (float)2.06f, (float)-2.6f));
        this.legFrontLeft.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-2.0f, (float)0.35f));
        this.tail.m_252899_(KeyframeAnimations.m_253186_((float)0.0f, (float)29.9f, (float)0.0f));
        this.tail.m_252854_(KeyframeAnimations.m_253126_((float)1.24f, (float)-6.7f, (float)-1.49f));
        this.mane.m_252899_(KeyframeAnimations.m_253186_((float)-12.78f, (float)7.97f, (float)26.29f));
        this.mane.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-2.79f, (float)0.35f));
        this.root.m_252899_(KeyframeAnimations.m_253186_((float)22.48072f, (float)-0.95645f, (float)132.3099f));
        this.root.m_252854_(KeyframeAnimations.m_253126_((float)2.0f, (float)-8.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().m_252899_(KeyframeAnimations.m_253186_((float)37.09314f, (float)13.50103f, (float)-46.63682f));
            this.earRight.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.12f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().m_252899_(KeyframeAnimations.m_253186_((float)32.49638f, (float)13.81807f, (float)-32.61916f));
            this.earLeft.get().m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.51f, (float)0.0f));
        }
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.f_104205_ = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.f_104205_ = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.f_104205_ = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.f_104205_ = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = this.head.f_104204_ + netHeadYaw * (dog.m_21825_() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.f_104203_ = dog.getTailRotation();
            this.tail.f_104204_ = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.f_104203_;
            this.headYRot0 = this.head.f_104204_;
            this.realHeadZRot0 = this.realHead.f_104205_;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.f_104203_;
        }
        anim.rootRotation().ifPresent(x -> this.root.f_104204_ += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.m_171331_().forEach(x -> x.m_233569_());
        this.realHead.m_233569_();
        this.realTail.m_233569_();
        this.earLeft.ifPresent(ear -> ear.m_233569_());
        this.earRight.ifPresent(ear -> ear.m_233569_());
    }

    public void copyFrom(DogModel dogModel) {
        this.root.m_104315_(dogModel.root);
        this.head.m_104315_(dogModel.head);
        this.realHead.m_104315_(dogModel.realHead);
        this.body.m_104315_(dogModel.body);
        this.mane.m_104315_(dogModel.mane);
        this.legBackRight.m_104315_(dogModel.legBackRight);
        this.legBackLeft.m_104315_(dogModel.legBackLeft);
        this.legFrontRight.m_104315_(dogModel.legFrontRight);
        this.legFrontLeft.m_104315_(dogModel.legFrontLeft);
        this.tail.m_104315_(dogModel.tail);
        this.realTail.m_104315_(dogModel.realTail);
    }

    public void resetPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.m_233569_();
            this.tail.f_104203_ = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.m_233569_();
            this.head.f_104203_ = this.headXRot0;
            this.head.f_104204_ = this.headYRot0;
            this.realHead.m_233569_();
            this.realHead.f_104205_ = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.m_233569_();
            this.head.f_104203_ = this.headXRot0;
            return;
        }
        part.m_233569_();
    }

    public void adjustAnimatedPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.f_104203_ > 3.0f) {
            part.f_104203_ = 3.0f;
        }
        if (part == this.head && part.f_104205_ != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.f_104205_ = part.f_104205_;
            part.f_104205_ = 0.0f;
        }
    }

    public Optional<ModelPart> searchForPartWithName(String name) {
        if (this.root.m_233562_(name)) {
            return Optional.of(this.root.m_171324_(name));
        }
        if (name.equals("root")) {
            return Optional.of(this.root);
        }
        Optional<ModelPart> partOptional = this.root.m_171331_().filter(part -> part.m_233562_(name)).findFirst();
        return partOptional.map(part -> part.m_171324_(name));
    }

    protected void correctInitalPose() {
        PartPose tailPose = this.tail.m_233566_();
        float tailX = tailPose.f_171405_;
        float tailY = tailPose.f_171406_;
        float tailZ = tailPose.f_171407_;
        this.tail.m_233560_(PartPose.m_171419_((float)tailX, (float)tailY, (float)tailZ));
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.f_104207_ = visible;
        this.body.f_104207_ = visible;
        this.legBackRight.f_104207_ = visible;
        this.legBackLeft.f_104207_ = visible;
        this.legFrontRight.f_104207_ = visible;
        this.legFrontLeft.f_104207_ = visible;
        this.tail.f_104207_ = visible;
        this.mane.f_104207_ = visible;
    }

    public void m_102624_(EntityModel<Dog> model) {
        super.m_102624_(model);
        if (!this.scaleBabyDog()) {
            model.f_102610_ = false;
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        p_102038_ *= this.wetShade;
        p_102039_ *= this.wetShade;
        p_102040_ *= this.wetShade;
        Vector3f pivot = DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = this.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            pivot = custom_pivot;
        }
        p_102034_.m_85836_();
        p_102034_.m_85837_((double)(this.root.f_104200_ / 16.0f), (double)(this.root.f_104201_ / 16.0f), (double)(this.root.f_104202_ / 16.0f));
        p_102034_.m_85837_((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (this.root.f_104205_ != 0.0f) {
            p_102034_.m_252781_(Axis.f_252403_.m_252961_(this.root.f_104205_));
        }
        if (this.root.f_104204_ != 0.0f) {
            p_102034_.m_252781_(Axis.f_252436_.m_252961_(this.root.f_104204_));
        }
        if (this.root.f_104203_ != 0.0f) {
            p_102034_.m_252781_(Axis.f_252529_.m_252961_(this.root.f_104203_));
        }
        float xRot0 = this.root.f_104203_;
        float yRot0 = this.root.f_104204_;
        float zRot0 = this.root.f_104205_;
        float x0 = this.root.f_104200_;
        float y0 = this.root.f_104201_;
        float z0 = this.root.f_104202_;
        this.root.f_104203_ = 0.0f;
        this.root.f_104204_ = 0.0f;
        this.root.f_104205_ = 0.0f;
        this.root.f_104200_ = 0.0f;
        this.root.f_104201_ = 0.0f;
        this.root.f_104202_ = 0.0f;
        p_102034_.m_85836_();
        p_102034_.m_85837_((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        if (this.f_102610_ && this.scaleBabyDog()) {
            boolean headVisible0 = this.head.f_104207_;
            this.head.f_104207_ = false;
            p_102034_.m_85836_();
            this.root.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
            this.head.f_104207_ = headVisible0;
            p_102034_.m_85836_();
            p_102034_.m_85841_(2.0f, 2.0f, 2.0f);
            p_102034_.m_85837_(0.0, -0.5, 0.15);
            this.head.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
        } else {
            this.root.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
        }
        p_102034_.m_85849_();
        p_102034_.m_85849_();
        this.root.f_104203_ = xRot0;
        this.root.f_104204_ = yRot0;
        this.root.f_104205_ = zRot0;
        this.root.f_104200_ = x0;
        this.root.f_104201_ = y0;
        this.root.f_104202_ = z0;
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED;

    }
}

